/*
* Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* SPDX-License-Identifier:	GPL-2.0+
*/

#ifndef COCOA_IPL_CUST_PART_NAME
#error Need to define ipl_cust image partition name
#endif

#ifndef COCOA_IPL_CUST_BACKUP_PART_NAME
#error Need to define ipl_cust backup image partition name
#endif

#ifndef COCOA_IPL_CUST_SIZE
#error Need to define IPL_CUST partition size
#endif

#ifndef COCOA_IPL_CUST_BOOT_ADDRESS
#error Need to define the IPL_CUST boot address
#endif

#if !defined(COCOA_BLUE_SIGNATURE_VERIFICATION_PSS) || !defined(COCOA_BLUE_SIGNATURE_VERIFICATION_PKCS)
#error Need to define RSA padding mode
#endif

#if (COCOA_BLUE_SIGNATURE_VERIFICATION_PSS == COCOA_BLUE_SIGNATURE_VERIFICATION_PKCS)
#error Only one RSA padding mode can be active
#endif

#define COCOA_NEXT_STAGE_PART_NAME COCOA_IPL_CUST_PART_NAME
#define COCOA_NEXT_STAGE_BACKUP_PART_NAME COCOA_IPL_CUST_BACKUP_PART_NAME
#define COCOA_NEXT_STAGE_PART_SIZE COCOA_IPL_CUST_SIZE
#define COCOA_NEXT_STAGE_BOOT_ADDRESS COCOA_IPL_CUST_BOOT_ADDRESS

#define IPL_IMAGE_MAGIC_OFFSET                  4
#define IPL_IMAGE_SIZE_OFFSET                   8

#define IPL_CUST_HEADER_SIZE                   20

#define image_get_ipl_size(a)                   (*((volatile U16*) (a + IPL_IMAGE_SIZE_OFFSET)))

#define get_ns_header_size() IPL_CUST_HEADER_SIZE
#define get_ns_image_size(hdr) image_get_ipl_size(hdr)
